package Application_test;
use base 'CGI::Application';
use strict;
use CGI::Application::Plugin::Config::General;
use CGI::Session qw/-ip-match/; 
use HTML::Template;
use Net::SMTP;
use HTML::Entities;
use Digest::MD5 qw/md5_hex/;

# Location of the configuration file
my $conf_file = 'conf/app.conf';

####### Param Legend #########
# cgi_code = code submitted by the user
# cgi_session_id = session ID submitted by the user
# cgi_email_from = email address supplied by the user
# cgi_subject = subject of the message supplied by the user
# cgi_message = email body supplied by the user
# cgi_success = marks whether the CGI object was retrieved (might be dropped).
# session = CGI::Session object
# app_output = message displayed by the application. 
#	Also used to ensure that no error messages exist prior to emailing.
	
sub cgiapp_init {
	my $self = shift;
	$self->conf->init(-ConfigFile => $conf_file);
};

sub setup {
	my $self = shift;
	$self->run_modes(
		'show_code' => 'show_code',
		'show_form' => 'show_form',
		'send_mail' => 'send_mail',
		'show_pic' => 'show_pic',
		'error_mode' => 'error_mode'
	);
	$self->start_mode('show_code');
	$self->mode_param('rm');
	$self->error_mode('error_mode');

	my $sid = $self->query->param('sid');
	$sid =~ s/[^a-z0-9]//;
	$self->param('cgi_session_id',$sid);

	# Create or Resume session.
	my $tmp_directory = $self->conf->param('TMP_DIRECTORY');
	$self->param('session',new CGI::Session(
					"driver:DB_File",
					$self->param('cgi_session_id'),
					{Directory=>$tmp_directory}
				)
	);

	my $code = $self->query->param('code');
	$code =~ s/[^a-zA-Z]//;
	$code = md5_hex(uc($code),$self->param('cgi_session_id'));
	$self->param('cgi_code',$code);

	# Check email address validity
	my $from = $self->query->param('email');
	if ($from =~/^[a-zA-Z0-9]+(\.[a-zA-Z0-9\-]+)*\@(?#
		Allow underscore character only if email is based on subdomain
		)([a-zA-Z0-9\-]+\.)*(?#		
		Domain name starts with alpha
		)[a-zA-Z0-9](?#
		Alpha can be followed by allowed chars
		)([a-zA-Z0-9\-]){1,61}(?#
		Domain name ends with alphanumeral and not a dash
		)[a-zA-Z0-9](?#
		Check extension 1 dot followed by 2 to 4 alpha
		)\.[a-zA-Z]{2,4}$/) { 

		$self->param('cgi_email_from',$from);	
	} elsif ($self->query->param('rm') eq 'send_mail') {
		$self->param('app_output',$self->conf->param('BAD_EMAIL_ADDRESS_MESSAGE'));
	};
	
	# Filter subject
	my $subject = $self->query->param('subject');
	HTML::Entities::encode($subject);
	$self->param('cgi_subject',$subject);
	
	my $message = $self->query->param('message');
	$self->param('cgi_message',$message);
};

sub cgiapp_get_query {
	# Called when the CGI query object is retrieved. 
	# This section was added to implement size checking to the script
	my $self = shift;
	use CGI;
	$CGI::DISABLE_UPLOADS = 1;
	$CGI::POST_MAX = 100*1024;
	my $query = CGI->new();
	my $error = $query->cgi_error;
	if ($query->cgi_error) { 
		my $app_message = 'Your message exceeds the maximum allowed size<br> Please try again';
	};
	return $query;
}

sub cgiapp_prerun {
	# Called before the selected run_mode is run
	my $self = shift;
	my $run_mode = shift;
	my $output = '';
	
	# Checks in this file are placed in reverse order of priority
	# the last check being the one who's value is sent to $run_mode
	
	
	

	# Run CGI checks 
	# ______________
	# CGI object was retrieved with no errors.
	if ($self->query->cgi_error) {
		$self->param('app_output',$self->conf->param('CGI_ERROR_MESSAGE').'<br>');
	};
	
	if ($run_mode ne 'show_code') {
	
	# Check if the session exists.
	if (($self->param('cgi_session_id')) and ($self->param('session')->id ne $self->param('cgi_session_id'))) {
			$self->param('app_output',$self->conf->param('EXPIRED_MESSAGE').'<br>');
		};
	
		# Subject exists
		unless ($self->param('cgi_subject'))  {
			$self->param('app_output',$self->conf->param('BLANK_SUBJECT_MESSAGE').'<br>');
		};
		
		if (length $self->param('cgi_subject') > $self->conf->param('MAXIMUM_SUBJECT_LENGTH') ) {
			$self->param('app_output',$self->conf->param('MAXIMUM_SUBJECT_LENGTH_MESSAGE').'<br>');
		};
		
		# Message exists
		unless ($self->param('cgi_message')) {
			$self->param('app_output',$self->conf->param('BLANK_SUBJECT_MESSAGE').'<br>');
		};
	
		# Code is correct 
		unless ($self->param('cgi_code') eq $self->param('session')->param('code')) {
			$self->param('app_output',$self->conf->param('CODE_ERROR_MESSAGE').'<br>');
		};
		
		# Check if the session exists.
		if (($self->param('cgi_session_id')) and ($self->param('session')->id ne $self->param('cgi_session_id'))) {
			$self->param('app_output',$self->conf->param('EXPIRED_MESSAGE').'<br>');
		};

	};
	# Check for input sanity and send message. 
	# ________________________________________
	# The sanity includes several repeat checks to avoid a problem is the 
	# webmaster keeps a configuration line blank and app_outout is still '' 
	#
	# Session exists 
	# Code correct 
	# Run mode = send_mail
	# cgi_success param = 1
	# no other entity is complaining a message

	if (($self->param('session')->id eq $self->param('cgi_session_id')) and ($self->param('cgi_code') eq $self->param('session')->param('code')) and ($run_mode eq 'send_mail') and ($self->param('app_output') eq '')) {
	
		# Change $run_mode value to prevent further checks.
		$run_mode = 'show_code';
		$self->prerun_mode($run_mode);
		

		if (my $smtp = Net::SMTP->new($self->conf->param('SMTP_SERVER'),
                        Hello => $self->conf->param('SMTP_SERVER'),
                        Timeout => 30,
                        Debug => 1
                        )) {

			$smtp->mail($self->param('cgi_email_from'));
			$smtp->to($self->conf->param('EMAIL_ADDRESS'));
			$smtp->data();
			$smtp->datasend("From: ".$self->param('cgi_email_from')."\n");
			$smtp->datasend("To: ".$self->conf->param('EMAIL_ADDRESS')."\n");
			$smtp->datasend("Subject: ".$self->param('cgi_subject')."\n\n");
			$smtp->datasend("________________________________________\n\n");
			$smtp->datasend("FusionPanels.com Easy Form Mail message\n");
			$smtp->datasend("________________________________________\n\n");
			$smtp->datasend($self->param('cgi_message'));
			$smtp->dataend();
			$smtp->quit;

			$self->param('app_output',$self->conf->param('SUCCESS_MESSAGE').'<br>');

			# Delete session and flush to disk
			$self->param('session')->delete	;
			$self->param('session')->flush;
			
			# Create new session instead.
			$self->param('session',new CGI::Session(
							"driver:DB_File",
							undef,
							{Directory=>$self->conf->param('TMP_DIRECTORY')}
						)
			
			);
		} else {
			$self->param('app_output',$self->conf->param('UNABLE_TO_CONNECT_MESSAGE'));
		};
	};
	
	# Set session parameters and flush data to disk
	if ($self->param('session')->id ne $self->param('cgi_session_id')) {
		$self->prerun_mode('show_code');
		$self->param('session')->expire(1200);
		$self->param('session')->flush;
	};
	
	# Check if authorized (triggered if conditions above are not met and $run_mode still pointing to 'send_mail'
	if (($run_mode ne 'show_code') and ($run_mode ne 'show_pic')) {
		$self->prerun_mode('show_code');
		$self->param('app_output',$self->param('app_output')."<br>".$self->conf->param('UNAUTHORIZED_MESSAGE')."<br>");
		
	};

	# Check if configuration file is writable.
	if (-w $conf_file) {
		$self->param('fatal_error','configuration_writable'); 
		$self->prerun_mode('error_mode');
	} ;
};

sub teardown {
	# Called each time a runmode is completed.
	my $self = shift;
	my $session = $self->param('session');
	undef($session);
};

sub error_mode {
	# Called when an error is trapped in the eval() of a run_mode
	# Allows a graceful death.
	my $self = shift;
	my $error = $self->param('fatal_error');
	unless ($error) {
		$error = 'default';
		};
	my $template = HTML::Template->new(filename=>"sys/$error.tpl");
	return $template->output;
 };

sub show_code {
	# Displays form that includes a scrambled code embedded in an image.
	my $self = shift;
	my $template = HTML::Template->new(filename=>'templates/code_page.tpl');
	my $head = "<form method='post'>\n";
	$template->param(HEAD_INSERT=>$head);
	my $form = $self->param('app_output')."<br>";
	$form .= "<table border='0' cellpadding='2' cellspacing='2' style='border-collapse: collapse' bordercolor='#111111' width='100%'>";
	$form .= "<tr>\n";
	$form .= "<img src=?rm=show_pic&sid=".$self->param('session')->id.">\n"; 
	$form .= "<br>\n";
	$form .= "<b>Code above </b><br>\n";
	$form .= "<input type='text' name='code'><br></tr></table>\n";
	$form .= "<input type='hidden' name='rm' value='send_mail'><br>\n";
	$form .= "<input type='hidden' name='sid' value='".$self->param('session')->id."'>\n";
	$form .= "<input type='submit' Value='Send'></form>\n";
	$template->param(CODE_INSERT=>$form);	
	return $template->output;
};

sub send_mail {
	die ();
};

sub show_pic {
	# Sends a png image containing a scrambled code
	my $self = shift;
	require FusionPanelsScramble;
	my $image = Scrambled->new();
	$image->generate();
	$self->header_add(-type=>'image/png');	
	$self->param('session')->param('code',md5_hex(uc($image->{'digits'}),$self->param('cgi_session_id')));
	return $image->{'scrambled_image'};
};

1;

