use GD;
use strict;

package Scrambled;

sub new {
	my $scramble = {
		## Image specific attributes 
		"image_width" => my $width = 150, # Width of image
		"image_height" => my $height = 75, # Height of image
		"image_type" => my $type = 'png', # Type of image (png, jpeg)
		"canvas" => my $canvas, # Image in progress
		"scrambled_image" => my $scrambled_image,# The final scrambled image
		## Digits specific attributes 
		"digits" => my $digits, # The scrambled code included in the image
		"digits_number" => my $digits_number = 4, # Number of digits in the random number
		"digits_repeat" => my $digits_repeat = 1 ,
		"random_fonts" => my @random_fonts = [("fonts/luxisri.ttf"),("fonts/arial.ttf"),("fonts/times.ttf")], ## Fonts randomly used in digits generation
		"shapes_number" => my $shapes = 3, # Number of random shapes drawn for each number
		"shapes_follow_font_color" => my $shapes_follow_font_color = 0,
		"shapes_color" => my @shapes_color = [(255,255,255)], # RGB values of the shapes color if shapes do not follow random font colors in option above
		## Text tag specific attributes
		"text_size" => my $text_size = 7, 
		"text_font" => my $text_font = "/usr/X11R6/lib/X11/fonts/TTF/luxisri.ttf",
		"text_border_distance" => my $text_border_distance = 10,
		"text_color" => my $text_color = [(0,0,0)] # RGB values of the text tag colors
	};
	bless $scramble,'Scrambled';
	return $scramble;
};

sub draw_shapes {
	my $scramble = shift ;
	my @shapes_color = @_;
	if ($scramble->{'shapes_follow_font_color'} != 1) {
		@shapes_color = @{$scramble->{'shapes_color'}};
	};
	my $loops = $scramble->{'shapes_number'};
	for (my $counter=0;$counter<$loops;$counter++){
		$scramble->{'canvas'}->arc(rand($scramble->{'image_width'}),rand($scramble->{'image_height'}),rand($scramble->{'image_height'}),rand($scramble->{'image_height'}),rand(360),rand(360),$scramble->{'canvas'}->colorAllocate(@shapes_color));
	};
	return $scramble;
};

sub print_text {
	# Print the text indicating the number of digits in the image
	my $scramble = shift;
	my @text_colors = @{$scramble->{'text_color'}};
	$scramble->{'canvas'}->stringFT($scramble->{'canvas'}->colorAllocate(@text_colors), $scramble->{'text_font'},$scramble->{'text_size'}, 0,20,$scramble->{'image_height'}-$scramble->{'text_border_distance'} ,"Code has $scramble->{'digits_number'} capital letters");
	return $scramble;
};

sub generate {
	my $scramble = shift;
	$scramble->{'canvas'} = new GD::Image( $scramble->{'image_width'},$scramble->{'image_height'});
	
	for (my $counter= 0;$counter<$scramble->{'digits_number'};$counter++) {
		srand ();
		my $random = int ((rand(25) +65));
		my $letter = chr($random);
		$scramble->{'digits'} .= $letter; 
		my @font = @{$scramble->{'random_fonts'}};
		$scramble->{'canvas'}->fill(1,1,$scramble->{'canvas'}->colorAllocate(rand(55)+200,rand(55)+200,rand(55)+200));
		my @text_random_color = (rand(200),rand(200),rand(200));
		for (my $digits_repeat = 0; $digits_repeat < $scramble->{'digits_repeat'};$digits_repeat++) {
			$scramble->{'canvas'}->stringFT($scramble->{'canvas'}->colorAllocate(@text_random_color), $font[int(rand(2)+1)], rand(10)+15,rand(0.5)-0.25,$counter*25+10,int(rand(10)+$scramble->{'image_height'}/2) , $letter);
		};
		# Draw random shapes
		$scramble->draw_shapes(@text_random_color);
		my $temp = $scramble->{'image_type'};
		$scramble->{'scrambled_image'}=$scramble->{'canvas'}->$temp;
	};
	$scramble->print_text();
	my $image_type = $scramble->{'image_type'};
	$scramble->{'scrambled_image'}=$scramble->{'canvas'}->$image_type;
	return $scramble;
};

1;